// To parse this JSON data, do
//
//     final currentZoneModel = currentZoneModelFromJson(jsonString);

import 'dart:convert';
import 'package:fixit_user/models/currency_model.dart';

/* CurrentZoneModel currentZoneModelFromJson(String str) =>
    CurrentZoneModel.fromJson(json.decode(str));

String currentZoneModelToJson(CurrentZoneModel data) =>
    json.encode(data.toJson()); */

class CurrentZoneModel {
  bool? success;
  List<Datum1>? data;

  CurrentZoneModel({
    this.success,
    this.data,
  });

  factory CurrentZoneModel.fromJson(Map<String, dynamic> json) =>
      CurrentZoneModel(
        success: json["success"],
        data: json["data"] == null
            ? []
            : List<Datum1>.from(json["data"]!.map((x) => Datum1.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class Datum1 {
  int? id;
  String? name;
  int? currencyId;
  CurrencyModel? currency;

  Datum1({
    this.id,
    this.name,
    this.currencyId,
    this.currency,
  });

  factory Datum1.fromJson(Map<String, dynamic> json) => Datum1(
        id: json["id"],
        name: json["name"],
        currencyId: json["currency_id"],
        currency: json["currency"] == null
            ? null
            : CurrencyModel.fromJson(json["currency"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "currency_id": currencyId,
        "currency": currency?.toJson(),
      };
}

class Currency {
  int? id;
  String? code;
  String? symbol;
  int? noOfDecimal;
  int? exchangeRate;
  String? thousandsSeparator;
  String? decimalSeparator;
  int? systemReserve;
  int? status;
  dynamic createdById;
  DateTime? createdAt;
  DateTime? updatedAt;
  dynamic deletedAt;
  List<Media>? media;

  Currency({
    this.id,
    this.code,
    this.symbol,
    this.noOfDecimal,
    this.exchangeRate,
    this.thousandsSeparator,
    this.decimalSeparator,
    this.systemReserve,
    this.status,
    this.createdById,
    this.createdAt,
    this.updatedAt,
    this.deletedAt,
    this.media,
  });

  factory Currency.fromJson(Map<String, dynamic> json) => Currency(
        id: json["id"],
        code: json["code"],
        symbol: json["symbol"],
        noOfDecimal: json["no_of_decimal"],
        exchangeRate: json["exchange_rate"],
        thousandsSeparator: json["thousands_separator"],
        decimalSeparator: json["decimal_separator"],
        systemReserve: json["system_reserve"],
        status: json["status"],
        createdById: json["created_by_id"],
        createdAt: json["created_at"] == null
            ? null
            : DateTime.parse(json["created_at"]),
        updatedAt: json["updated_at"] == null
            ? null
            : DateTime.parse(json["updated_at"]),
        deletedAt: json["deleted_at"],
        media: json["media"] == null
            ? []
            : List<Media>.from(json["media"]!.map((x) => Media.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "code": code,
        "symbol": symbol,
        "no_of_decimal": noOfDecimal,
        "exchange_rate": exchangeRate,
        "thousands_separator": thousandsSeparator,
        "decimal_separator": decimalSeparator,
        "system_reserve": systemReserve,
        "status": status,
        "created_by_id": createdById,
        "created_at": createdAt?.toIso8601String(),
        "updated_at": updatedAt?.toIso8601String(),
        "deleted_at": deletedAt,
        "media": media == null
            ? []
            : List<dynamic>.from(media!.map((x) => x.toJson())),
      };
}

class Media {
  int? id;
  String? modelType;
  int? modelId;
  String? uuid;
  String? collectionName;
  String? name;
  String? fileName;
  String? mimeType;
  String? disk;
  String? conversionsDisk;
  int? size;
  List<dynamic>? manipulations;
  CustomProperties? customProperties;
  List<dynamic>? generatedConversions;
  List<dynamic>? responsiveImages;
  int? orderColumn;
  DateTime? createdAt;
  DateTime? updatedAt;
  String? originalUrl;
  String? previewUrl;

  Media({
    this.id,
    this.modelType,
    this.modelId,
    this.uuid,
    this.collectionName,
    this.name,
    this.fileName,
    this.mimeType,
    this.disk,
    this.conversionsDisk,
    this.size,
    this.manipulations,
    this.customProperties,
    this.generatedConversions,
    this.responsiveImages,
    this.orderColumn,
    this.createdAt,
    this.updatedAt,
    this.originalUrl,
    this.previewUrl,
  });

  factory Media.fromJson(Map<String, dynamic> json) => Media(
        id: json["id"],
        modelType: json["model_type"],
        modelId: json["model_id"],
        uuid: json["uuid"],
        collectionName: json["collection_name"],
        name: json["name"],
        fileName: json["file_name"],
        mimeType: json["mime_type"],
        disk: json["disk"],
        conversionsDisk: json["conversions_disk"],
        size: json["size"],
        manipulations: json["manipulations"] == null
            ? []
            : List<dynamic>.from(json["manipulations"]!.map((x) => x)),
        customProperties: json["custom_properties"] == null
            ? null
            : CustomProperties.fromJson(json["custom_properties"]),
        generatedConversions: json["generated_conversions"] == null
            ? []
            : List<dynamic>.from(json["generated_conversions"]!.map((x) => x)),
        responsiveImages: json["responsive_images"] == null
            ? []
            : List<dynamic>.from(json["responsive_images"]!.map((x) => x)),
        orderColumn: json["order_column"],
        createdAt: json["created_at"] == null
            ? null
            : DateTime.parse(json["created_at"]),
        updatedAt: json["updated_at"] == null
            ? null
            : DateTime.parse(json["updated_at"]),
        originalUrl: json["original_url"],
        previewUrl: json["preview_url"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "model_type": modelType,
        "model_id": modelId,
        "uuid": uuid,
        "collection_name": collectionName,
        "name": name,
        "file_name": fileName,
        "mime_type": mimeType,
        "disk": disk,
        "conversions_disk": conversionsDisk,
        "size": size,
        "manipulations": manipulations == null
            ? []
            : List<dynamic>.from(manipulations!.map((x) => x)),
        "custom_properties": customProperties?.toJson(),
        "generated_conversions": generatedConversions == null
            ? []
            : List<dynamic>.from(generatedConversions!.map((x) => x)),
        "responsive_images": responsiveImages == null
            ? []
            : List<dynamic>.from(responsiveImages!.map((x) => x)),
        "order_column": orderColumn,
        "created_at": createdAt?.toIso8601String(),
        "updated_at": updatedAt?.toIso8601String(),
        "original_url": originalUrl,
        "preview_url": previewUrl,
      };
}

class CustomProperties {
  String? language;

  CustomProperties({
    this.language,
  });

  factory CustomProperties.fromJson(Map<String, dynamic> json) =>
      CustomProperties(
        language: json["language"],
      );

  Map<String, dynamic> toJson() => {
        "language": language,
      };
}
